import os
from flask import Flask
from flask_sqlalchemy import SQLAlchemy

db_filename = "users.db"
db_path = f"instance/{db_filename}"

app = Flask(__name__)
app.config['SQLALCHEMY_DATABASE_URI'] = 'sqlite:///users.db'
db = SQLAlchemy(app)

# User ORM model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)

# Custom Session Model
class Session(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    user_id = db.Column(db.Integer, db.ForeignKey(User.id), nullable=False)
    active = db.Column(db.Boolean, default=True, nullable=False)
    expires_at = db.Column(db.String, nullable=False)

# Delete existing database file
if os.path.exists(db_path):
    os.remove(db_path)  
    print(f"Deleted existing database file: '{db_path}'")

# Create the database and a default user
with app.app_context():
    db.create_all()
    print(f"Successfully created a new database: '{db_path}'")

    admin_user = User.query.filter(User.username=="admin").first()
    if not admin_user:
        admin_user = User(username="admin", password="password123", name="Admin User", email="admin@example.com")
        db.session.add(admin_user)
        db.session.commit()
        print("Default user added -> Username: 'admin', Password: 'password123'")
