from flask import Flask, request, redirect

app = Flask(__name__)

# In-memory list of comments (lost when the app restarts)
comments = []

template_str = """<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FakeTube - Video Page</title>
    <link href="/static/style.css" rel="stylesheet" />
</head>
<body>
    <div class="container">
        <h1>FakeTube</h1>
        <div class="video-container">
            <a href="https://www.youtube.com/watch?v=jNQXAC9IVRw">
                <img src="/static/thumbnail.jpg" alt="Fake Video Thumbnail">
                <div class="play-button"></div>
            </a>
        </div>
        
        <div class="comments-section">
            <h2>Comments</h2>
            <form method="post" action="/comment">
                <input type="text" name="comment" placeholder="Add a public comment..." required>
                <button type="submit">Comment</button>
            </form>
        
            {0}
        </div>
    </div>
</body>
</html>"""

@app.route("/comment", methods=["POST"])
def post_comment():
    # Get user input
    user_comment = request.form.get("comment", "")
    
    # Store it without any sanitisation or escaping
    comments.append(user_comment)

    return redirect("/")

@app.route("/", methods=["GET"])
def index():
    comment_elements = []
    for c in comments:
        comment_elements.append("""
                <div class="comment">
                    <strong>Anonymous says:</strong><br>
                    {0} 
                    <hr>
                </div>
        """.format(c))
    
    comment_str = "\n".join(comment_elements)
    page_str = template_str.format(comment_str)

    return page_str


app.run(debug=True, reloader_type='stat', port=5000)
